#version 330
#extension GL_EXT_gpu_shader4 : enable
// cubic desertMod01.fsh   by   jngl

//https://www.shadertoy.com/view/XssSDS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define RENDER_DIST 400
#define SPEED 20.0
#define CAM_DIST 70.0
//montaigne scale
#define HEIGHT 200.0
#define WIDTH 0.3

float rand(vec2 n)
{
  return 0.5 + 0.5 * fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

float interpolation(float a, float b, float alpha){
	return mix(a, b, 0.5-cos(alpha*3.14)/2.0);
}

float noise(vec2 p, vec2 size){
	
	
	float h11=rand(vec2(floor(p.x/size.x), floor(p.y/size.y)));
	float h12=rand(vec2(floor(p.x/size.x), floor(p.y/size.y+1.0)));
	float h21=rand(vec2(floor(p.x/size.x+1.0), floor(p.y/size.y)));
	float h22=rand(vec2(floor(p.x/size.x+1.0), floor(p.y/size.y+1.0)));
	
	float px=fract(p.x/size.x);
	float py=fract(p.y/size.y);
	
	return interpolation(interpolation(h11, h21, px), interpolation(h12, h22, px), py);
}

float perlinnoise(vec2 p){
	return ( noise(p*WIDTH, vec2(8.0)) * 0.25+noise(p*WIDTH, vec2(32.0)) )*HEIGHT;	
}

float mymod(float value, float modulus) {
  return mod((mod(value, modulus) + modulus), modulus);
}

float intbound(float s, float ds) {
	// Find the smallest positive t such that s+t*ds is an integer.
	if (ds < 0.0) {
		s=-s;
		ds=-ds;
	}
	s = mod(s, 1.0);
	// problem is now s+t*ds = 1
	return (1.0-s)/ds;
}

vec3 intbound(vec3 s, vec3 ds){
	return vec3(intbound(s.x, ds.x), intbound(s.y, ds.y), intbound(s.z, ds.z));	
}


vec4 raycast(vec3 camPos, vec3 rayDir, out vec3 normal){
	vec3 voxelPos=floor(camPos);
	vec3 rayStep=sign(rayDir);
	vec3 tMax=intbound(camPos, rayDir);
	vec3 delta=rayStep/rayDir;
	
	bvec3 mask;
	
	for(int i=0; i<RENDER_DIST;i++){
		bvec3 b1 = lessThan(tMax.xyz, tMax.yzx);
		bvec3 b2 = lessThanEqual(tMax.xyz, tMax.zxy);
		mask.x = b1.x && b2.x;
		mask.y = b1.y && b2.y;
		mask.z = b1.z && b2.z;
		
		tMax += vec3(mask) * delta;
		voxelPos += vec3(mask) * rayStep;
		
		if(voxelPos.y<perlinnoise(voxelPos.xz)){
			normal = -vec3(mask)*rayStep;
			return vec4(voxelPos, 1.0);
		}
	}
	normal = vec3(mask)*rayStep;
	return vec4(voxelPos, -1.0);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	//pixel coord (-1, 1)
	vec2 uv = (gl_FragCoord.xy / iResolution.xy)*2.0-1.0;
	
	//camera
	vec3 camPos=vec3(CAM_DIST-iTime*SPEED, HEIGHT*1.4, 150.0);
	camPos.y=perlinnoise(camPos.xz)+CAM_DIST*0.25;
	
	vec3 camView=vec3(-iTime*SPEED, 0.0, 50.0);
	camView.y=perlinnoise(camView.xz);

	vec3 camUp=vec3(0.0, 1.0, 0.0);
	
	//ray dir
	vec3 camDir=normalize(camView-camPos);
  	vec3 u=normalize(cross(camUp,camDir));
  	vec3 v=cross(camDir,u);
  	vec3 vcv=(camPos+camDir);
  	vec3 scrCoord=vcv+uv.x*u*0.8+uv.y*v*0.8;
  	vec3 rayDir=(scrCoord-camPos)*float(RENDER_DIST);
	
	//raycast
	vec3 normal;
	vec4 ret=raycast(camPos, rayDir, normal);
	vec3 p=floor(ret.xyz);
	float sky=ret.w;
	
	//color
	vec3 light=vec3(0.0, 1.0, 0.0);
	vec3 color=vec3(0.3, 0.3, 1.0);
	float diff=1.0;
	
	if(sky>0.0){
		//color=vec3(p.y/HEIGHT, p.x/150.0+0.5, p.z/150.0+0.5);
		color=texture2D(iChannel0, p.xz/150.0).xyz;
		diff=max(dot(light, normal), 0.0);
		diff=diff*0.3+0.7;
	}
	
	//fin
	gl_FragColor = vec4(color*diff,1.0);
}